<?php
/**
 * Product Loop Start
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

global $product, $woocommerce_loop;

// Store column count for displaying the grid
$custom_columns = isset( $woocommerce_loop['custom_columns'] ) ? $woocommerce_loop['custom_columns'] : false;
if ( !$custom_columns && !wc_get_loop_prop( 'is_shortcode' ) ) {
	wc_set_loop_prop( 'columns', apply_filters( 'loop_shop_columns', basel_get_opt( 'products_columns' ) ) );
}

$class = '';

if ( empty( $woocommerce_loop['masonry'] ) ) {
	$woocommerce_loop['masonry'] = ( basel_get_opt( 'products_masonry' ) ) ? 'enable' : 'disable';
}
if( ! empty( $woocommerce_loop['masonry'] ) && $woocommerce_loop['masonry'] == 'enable' ) {
	$class = 'grid-masonry';
}

$pagination = basel_get_opt( 'shop_pagination' );

$class .= ' pagination-' . $pagination;

// fix for price filter ajax
$min_price = isset( $_GET['min_price'] ) ? esc_attr( $_GET['min_price'] ) : '';
$max_price = isset( $_GET['max_price'] ) ? esc_attr( $_GET['max_price'] ) : '';
?>

<div class="products elements-grid basel-products-holder <?php echo esc_attr( $class ); ?> row grid-columns-<?php echo esc_attr( wc_get_loop_prop( 'columns' ) ); ?>" data-min_price="<?php echo esc_attr( $min_price ); ?>" data-max_price="<?php echo esc_attr( $max_price ); ?>" data-source="main_loop">